% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixest_env.R
\name{stepwise}
\alias{stepwise}
\alias{sw}
\alias{cstepwise}
\alias{csw}
\alias{stepwise0}
\alias{sw0}
\alias{cstepwise0}
\alias{csw0}
\title{Stepwise estimation tools}
\usage{
stepwise(...)

sw(...)

cstepwise(...)

csw(...)

stepwise0(...)

sw0(...)

cstepwise0(...)

csw0(...)
}
\arguments{
\item{...}{Represents formula variables to be added in a stepwise fashion to an estimation.}
}
\description{
Functions to perform stepwise estimations.
}
\details{
To include multiple independent variables, you need to use the stepwise functions. There are 4 stepwise functions associated to 4 short aliases. These are a) stepwise, stepwise0, cstepwise, cstepwise0, and b) sw, sw0, csw, csw0. Let's explain that.

Assume you have the following formula: \code{fml = y ~ x1 + sw(x2, x3)}. The stepwise function \code{sw} will estimate the following two models: \code{y ~ x1 + x2} and \code{y ~ x1 + x3}. That is, each element in \code{sw()} is sequentially, and separately, added to the formula. Would have you used \code{sw0} in lieu of \code{sw}, then the model \code{y ~ x1} would also have been estimated. The \code{0} in the name means that the model wihtout any stepwise element also needs to be estimated.

Finally, the prefix \code{c} means cumulative: each stepwise element is added to the next. That is, \code{fml = y ~ x1 + csw(x2, x3)} would lead to the following models \code{y ~ x1 + x2} and \code{y ~ x1 + x2 + x3}. The \code{0} has the same meaning and would also lead to the model without the stepwise elements to be estimated: in other words, \code{fml = y ~ x1 + csw0(x2, x3)} leads to the following three models: \code{y ~ x1}, \code{y ~ x1 + x2} and \code{y ~ x1 + x2 + x3}.
}
\examples{

base = iris
names(base) = c("y", "x1", "x2", "x3", "species")

# Regular stepwise
feols(y ~ sw(x1, x2, x3), base)

# Cumulative stepwise
feols(y ~ csw(x1, x2, x3), base)

# Using the 0
feols(y ~ x1 + x2 + sw0(x3), base)

}
