% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{check_conv_feols}
\alias{check_conv_feols}
\alias{summary.fixest_check_conv}
\title{Check the fixed-effects convergence of a \code{feols} estimation}
\usage{
check_conv_feols(x)

\method{summary}{fixest_check_conv}(object, type = "short", ...)
}
\arguments{
\item{x}{A \code{\link[fixest]{feols}} estimation that should contain fixed-effects.}

\item{object}{An object returned by \code{check_conv_feols}.}

\item{type}{Either "short" (default) or "detail". If "short", only the maximum absolute FOC are displayed, otherwise the 2 smallest and the 2 largest FOC are reported for each fixed-effect and each variable.}

\item{...}{Not currently used.

Note that this function first re-demeans the variables, thus possibly incurring some extra computation time.}
}
\value{
It returns a list of \code{N} elements, \code{N} being the number of variables in the estimation (dependent variable + explanatory variables +, if IV, endogenous variables and instruments). For each variable, all the first-order conditions for each fixed-effect are returned.
}
\description{
Checks the convergence of a \code{feols} estimation by computing the first-order conditions of all fixed-effects (all should be close to 0)
}
\examples{

base = setNames(iris, c("y", "x1", "x2", "x3", "species"))
base$FE = rep(1:30, 5)

# one estimation with fixed-effects + varying slopes
est = feols(y ~ x1 | species[x2] + FE[x3], base)

# Checking the convergence
conv = check_conv_feols(est)

# We can check that al values are close to 0
summary(conv)

summary(conv, "detail")



}
