% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux.R
\name{fixer_fluctuation}
\alias{fixer_fluctuation}
\title{Currency fluctuation}
\usage{
fixer_fluctuation(start_date, end_date, base = "EUR", symbols = NULL)
}
\arguments{
\item{start_date}{The start date of requested time period.}

\item{end_date}{The end date of requested time period.}

\item{base}{The base currency to index other currencies against. Defaults
to \code{"EUR"}. Other base currencies are only available on paid plans.}

\item{symbols}{A character vector of the symbols of currencies to return
exchange rates for, or a string for a single currency. Defaults to
\code{NULL} and returns all available currencies. See
\code{\link{fixer_symbols}} for details on symbol options.}
}
\value{
A tibble with the currency symbol, start rate, end rate, change and
change percentage over the requested time period. Each currency is given its
own row, with start rate, end rate, change and change percentage each in
their own columns.
}
\description{
Returns fluctuation in currency exchange rates for one or more
currencies compared to the base currency over a given period of time. The
maximum time frame is 365 days.

Currency fluctuation data is only available for
"Professional Plus" and "Enterprise" accounts.
}
\examples{
\dontrun{

x <- fixer_fluctuation(start_date = "2018-02-25", end_date = "2018-02-26",
symbols = c("USD", "JPY"))

}
}
\seealso{
fixer_time_series
}
