% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotratecurve-class.R
\name{interpolation_error}
\alias{interpolation_error}
\alias{interpolation_error,SpotRateCurve-method}
\title{Interpolation error}
\usage{
interpolation_error(x, ...)
}
\arguments{
\item{x}{a SpotRateCurve object.}

\item{...}{additional arguments. Currently unused.

The curve must have a interpolation set to compute the interpolation error.
This is useful to evaluate parametric methods like \linkS4class{NelsonSiegel} and
\linkS4class{NelsonSiegelSvensson}.}
}
\value{
A numeric value with the root mean squared error between the curve data point
and interpolated points.
}
\description{
Computes interpolation error as the root mean square error of differences
between interpolated terms and SpotRateCurve values.
}
\examples{
terms <- c(1, 11, 26, 27, 28)
rates <- c(0.0719, 0.056, 0.0674, 0.0687, 0.07)
curve <- spotratecurve(rates, terms, "discrete", "actual/365", "actual")
interpolation(curve) <- interp_nelsonsiegel(
  0.1229, -0.0606, 0.1004, 1.9174
)
interpolation_error(curve)
}
