% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.plcfit.R
\name{plot.plcfit}
\alias{plot.manyplcfit}
\alias{plot.plcfit}
\title{Plot a fitted vulnerability curve}
\usage{
\method{plot}{plcfit}(x, xlab = NULL, ylab = NULL, ylim = NULL,
  pch = 19, plotPx = TRUE, plotci = TRUE, plotdata = TRUE,
  add = FALSE, multiplier = NULL, selines = c("parametric", "bootstrap",
  "none"), plotrandom = FALSE, linecol = "black", linecol2 = "blue",
  pxlinecol = "red", pxcex = 0.7, citype = c("polygon", "lines"),
  what = c("relk", "embol"), ...)

\method{plot}{manyplcfit}(x, what = c("relk", "embol"), onepanel = FALSE,
  linecol = NULL, pointcol = NULL, pch = 19, legend = TRUE,
  legendwhere = "topright", ...)
}
\arguments{
\item{x}{A fitted curve returned by \code{fitplc}}

\item{xlab, ylab}{Optionally, X and Y axis labels (if not provided, a default is used).}

\item{ylim}{Optionally, Y-axis limits.}

\item{pch}{Optionally, the plotting symbol (default = 19, filled circles)}

\item{plotPx}{Logical (default TRUE), whether to plot a vertical line for the P50.}

\item{plotci}{Logical (default TRUE), whether to plot the confidence interval (if computed with bootci=TRUE).}

\item{plotdata}{Logical (default TRUE), whether to add the data to the plot.}

\item{add}{Logical (default FALSE), whether to add the plot to a current device. This is useful to overlay two plots or curves, for example.}

\item{multiplier}{Multiply the scaled data (for plotting).}

\item{selines}{Option for the confidence interval around Px, either 'parametric' (confidence interval computed with \code{\link{confint}}), 'bootstrap' (computed with non-parametric bootstrap) or 'none' (no plotting of the confidence interval).}

\item{plotrandom}{Logical. If TRUE (default is FALSE), plots the predictions for the random effects (only if random effects were included in the model fit).}

\item{linecol}{The color(s) of the fitted curve (or color of the random effects curves if plotrandom=TRUE).}

\item{linecol2}{The color of the fixed effects curve (if plotrandom=TRUE; otherwise ignored).}

\item{pxlinecol}{The color of the lines indicating Px and its confidence interval}

\item{pxcex}{Character size for the Px label above the Y-axis.}

\item{citype}{Either 'polygon' (default), or 'lines', specifying formatting of the confidence interval in the plot.}

\item{what}{Either 'relk' or 'embol'; it will plot either relative conductivity or percent embolism.}

\item{onepanel}{For plotting of many curve fits, plot all curves in one panel (TRUE) or in separate panels (FALSE)}

\item{pointcol}{The color(s) of the data points.}

\item{legend}{Logical (default TRUE), whether to include a simple legend when plotting multiple fits}

\item{legendwhere}{As in \code{\link{legend}}, specification of where to place legend (e.g. 'bottomleft'; coordinates not accepted)}

\item{\dots}{Further parameters passed to \code{plot}, or \code{points} (when \code{add=TRUE})}
}
\description{
Standard plots of fitted curves (objects returned by \code{\link{fitplc}}, \code{\link{fitplcs}}, \code{\link{fitcond}} or \code{\link{fitconds}}), with plenty of options for customization.
}

