% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_params.R
\name{growth_params}
\alias{growth_params}
\title{A function to find growth parameters on fishbase}
\usage{
growth_params(sp, otolith = TRUE)
}
\arguments{
\item{sp}{A charachter value containing the species name}

\item{otolith}{A logical value. If TRUE, only results from otolith analysis are returned. If false, all growth studies will be returned.}
}
\value{
dataframe with available growth rate parameters from fishbase.
}
\description{
A function to find growth parameters of a species using rfishbase.
It returns a data frame containing K, t0 and Linf, the source.
This function is useful to see what is available on fishbase.
Nevertheless, we strongly recommend to check the source and only use otolith based studies.
}
\examples{
\dontrun{
library(fishflux)
growth_params("Lutjanus griseus")
}
}
\keyword{fish}
\keyword{fishbase}
\keyword{growth}
