# Welcome to fishRman [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.5582567.svg)](https://doi.org/10.5281/zenodo.5582567) [![DOI](https://joss.theoj.org/papers/10.21105/joss.03467/status.svg)](https://doi.org/10.21105/joss.03467) <!-- badges: start --> [![Lifecycle: experimental](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html#experimental) <!-- badges: end -->

`fishRman` is a bundle of analytics tools for fisheries scientists. Data on fishing effort by 'Global Fishing Watch' can be retrieved via the package's API, as well as data on Exclusive Economic Zones by 'Marine Regions'. A 'shiny' R App is included for a 'no-code' solution for retrieval, analysis, and visualization. 

## Useful links
You can use the dashboard and learn more about the code, the software, the data, and the people behind them via:

- The [**Handbook**](https://raw.githubusercontent.com/Shyentist/fish-r-man/main/inst/app/www/doc/Handbook.pdf) constitutes `fishRman`'s official instructions for use. Regardless of the prior knowledge of the user, reading the **Handbook** is key to the correct usage of the software.
- Website of [**Open-Source for Marine and Ocean Sciences (OSMOS)**](https://osmos.xyz/), which is our research group. If you like our projects, and would like a more interactive role, consider joining our [**Discord server**](https://discord.com/invite/W2unKxKbp7), or [**donating**](https://www.buymeacoffee.com/osmos).
- The **Dashboard** can be accessed here: **https://shyentist.shinyapps.io/fish-r-man/**

## How to quote
- Software: Buonomo, P., (2021). fishRman: A Shiny R Dashboard improving Global Fishing Watch data availability. *Journal of Open Source Software*, 6(66), 3467, **https://doi.org/10.21105/joss.03467**
- Software: Buonomo, P. (2023). fishRman: The Fisheries Scientist's Toolbox. R package, **https://doi.org/10.5281/zenodo.5582567**
- Fishing Effort Data: Global Fishing Watch, (2021). **https://globalfishingwatch.org/**
- EEZ Boundaries: Marine Regions. **https://www.marineregions.org/**

## How to become a contributor
First things first, you might want to take a look at the Issues page. There, I listed some tasks that I reckon the project needs. If you don't find anything that you can do, you can still run the code and make up **your own** opinion on what is needed. From there, you can either file this new Issue and forget about it, or file it and handle it yourself. The pull requests should be made onto the `pull-requests` branch.

## Get in touch
If you are interested in contributing, planning, chatting, or if you have any issues, you can contact me at **pasqualebuonomo@hotmail.it**
