% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_email.R
\name{change_email}
\alias{change_email}
\title{Change email}
\usage{
change_email(id_token, email)
}
\arguments{
\item{id_token}{String. A Firebase Auth ID token for the user.}

\item{email}{String. User's new email.}
}
\value{
A named list with the following items:
\itemize{
\item \code{localId}:	The uid of the current user.
\item \code{email}:	User's email address.
\item \code{passwordHash}:	Hash version of password.
\item \code{providerUserInfo}:	A named list of of all linked provider objects which
contain "providerId" and "federatedId".
\item \code{idToken}:	New Firebase Auth ID token for user.
\item \code{refreshToken}:	A Firebase Auth refresh token.
\item \code{expiresIn}:	string	The number of seconds in which the ID token expires.
\item \code{error}:
\itemize{
\item \code{NULL} if no error code in response
\item A list of 2 if response was an error:
\itemize{
\item \code{code}: Error code
\item \code{message}: Error message
}
}
}
}
\description{
Change email
}
\details{
\strong{DISCLAIMER}: Changing a users's email requires that you disable email
enumeration protection for your firebase project. This is NOT recommended.
\itemize{
\item Learn about \href{https://cloud.google.com/identity-platform/docs/admin/email-enumeration-protection?hl=en&authuser=0}{email enumeration protection}
\item Visit \href{https://firebase.google.com/docs/reference/rest/auth#section-change-email}{Firebase Auth REST API docs}
for more details
}
}
\examples{
\dontrun{
  # first sign in user and get the 'id_token':
  user <- sign_in(email = "user@gmail.com", password = "password")
  id_token <- user$idToken

  # change email:
  response <- change_email(
    id_token = id_token,
    email = "new.email@mail.com"
  )
  response
}
}
