% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{sum_down_regulation_bids_balancing_energy_market}
\alias{sum_down_regulation_bids_balancing_energy_market}
\title{The sum of the down-regulation bids in the Balancing energy market}
\usage{
sum_down_regulation_bids_balancing_energy_market(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains the hourly sum of the
down-regulation offers given by Finnish parties to the Balancing energy
market is published hourly with one hour delay, eg. information from
hour 07-08 is published at 9 o'clock.
}
\description{
Check https://data.fingrid.fi/en/dataset/the-sum-of-the-down-regualtion-bids-in-the-balancing-energy-market
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- sum_down_regulation_bids_balancing_energy_market(start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
