% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{other_power_transactions_down_regulation}
\alias{other_power_transactions_down_regulation}
\title{Other power transactions, down-regulation}
\usage{
other_power_transactions_down_regulation(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains other power transactions which are
necessary in view of the power system.
}
\description{
Check https://data.fingrid.fi/en/dataset/other-power-transactions-down-regulation
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- other_power_transactions_down_regulation(
    start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
