% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{FFR_received_bids}
\alias{FFR_received_bids}
\title{Fast Frequency Reserve FFR, received bids}
\usage{
FFR_received_bids(start_time = NA, end_time = NA, user_key = NA)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains the volume of received Fast
Frequency Reserve (FFR) bids. The volume of bids will be published
22:00 (EET) on previous evening. The Fast Frequency Reserve (FFR) is
procured to handle low-inertia situations. The needed volume of Fast
Frequency Reserve depends on the amount of inertia in the power system
and the size of the reference incident.
}
\description{
Check https://data.fingrid.fi/en/dataset/nopea-taajuusreservi-tarjoukset
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- FFR_received_bids(
    start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
