% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zcta_state_xwalk.R
\docType{data}
\name{zcta_state_xwalk}
\alias{zcta_state_xwalk}
\alias{zcta_state_xwalk2021}
\alias{zcta_state_xwalk2020}
\alias{zcta_state_xwalk2019}
\title{Relationship file (crosswalk) for ZCTAs by state}
\format{
\subsection{A data frame with 5 columns and various number of rows, depending on the year:}{

\describe{
\item{ZCTA}{5 digit ZCTA code.}
\item{st_code}{Federal Information Processing System (FIPS) Codes for States.}
\item{county}{County name within the state that the ZCTA intersects/corresponds to.}
\item{state}{State full name corresponding to the FIPS code.}
\item{st_abb}{Two-letter state abbreviation.}
}
}

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 542995 rows and 5 columns.

An object of class \code{data.frame} with 523727 rows and 5 columns.
}
\source{
Census ZCTA-county relationship file (2010)
https://www.census.gov/geographies/reference-files/time-series/geo/relationship-files.2010.html#list-tab-1709067297
Geocorr ZCTA-county relationship file (2020)
https://mcdc.missouri.edu/applications/geocorr2022.html
County-state reference file (2019, 2020, 2021)
https://www.census.gov/programs-surveys/popest/geographies/reference-files.html
}
\usage{
zcta_state_xwalk2021

zcta_state_xwalk2020

zcta_state_xwalk2019
}
\description{
Each of these tables contains ZIP Code Tabulation Areas (ZCTAs), their
intersecting counties and the states (state name, abbreviation, state FIPS
code) they are nested in. It's used in \code{get_census_data()} for retrieving ZCTA-level census data by
state, as \code{\link[tidycensus:get_acs]{tidycensus::get_acs()}} (CRAN version) currently does not support
obtaining state-specific ZCTA-level data.
}
\keyword{datasets}
