% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddfply.R
\name{ddfply}
\alias{ddfply}
\title{ddfply}
\usage{
ddfply(ddfdir, groupby, fun = identity, collect = "none",
  temploc = getwd(), nbins = 10, chunk = 50000, spill = 1e+06,
  cores = 1, buffer = 1e+09, ...)
}
\arguments{
\item{ddfdir}{(string) path of ddf directory}

\item{groupby}{(character vector) Columns names to used to split the data(if 
missing, \code{fun} is applied on each chunk)}

\item{fun}{(object of class \emph{function}) function to apply on each subset
after the split}

\item{collect}{(string) Collect the result as \code{list} or \code{dataframe}
or \code{none}. \code{none} keeps the resulting ddo on disk.}

\item{temploc}{(string) Path where intermediary files are kept}

\item{nbins}{(positive integer) Number of directories into which the 
distributed dataframe (ddf) or distributed data object (ddo) is distributed}

\item{chunk}{(positive integer) Number of rows of the file to be read at a 
time}

\item{spill}{(positive integer) Maximum number of rows of any subset 
resulting from split}

\item{cores}{(positive integer) Number of cores to be used in parallel}

\item{buffer}{(positive integer) Size of batches of key-value pairs to be 
passed to the map OR Size of the batches of key-value pairs to flush to 
intermediate storage from the map output OR Size of the batches of 
key-value pairs to send to the reduce}

\item{...}{Arguments to be passed to \code{data.table} function asis.}
}
\value{
list or a dataframe or a TRUE(when collect is 'none').
}
\description{
performs chunk processing or split-apply-combine on the data
  in a distributed data frame(ddf)
}
\details{
see \code{\link{fileply}}
}
\examples{
write.table(mtcars, "mtcars.csv", row.names = FALSE, sep = ",")
# create a ddf by keeping `keepddf = TRUE`
co <- capture.output(temp <- fileply("mtcars.csv"
                                     , groupby = c("carb", "gear")
                                     , fun     = identity
                                     , collect = "list"
                                     , sep     =  ","
                                     , header  = TRUE
                                     , keepddf = TRUE)
                     , file = NULL
                     , type = "message"
                     )
# use the ddf instead of reading the CSV again
temp2 <- ddfply(file.path(strsplit(co[6], ": ")[[1]][2], "data")
                , groupby = c("gear")
                , fun     = identity
                , collect = "list"
                , sep     =  ","
                , header  = TRUE
                )
temp2
unlink("mtcars.csv")
unlink(strsplit(co[6], ": ")[[1]][2], recursive = TRUE)

}

