% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions.r
\name{cdf.plot}
\alias{cdf.plot}
\title{cdf.plot}
\usage{
cdf.plot(
  parent.df,
  category.col,
  category.label,
  response.col,
  x.label = "",
  x.limits = NULL,
  x.ticks = NULL,
  y.label = "",
  y.limits = c(0, 1),
  y.ticks = seq(0, 1, 0.2),
  line.size = 0.75,
  category.palette = c("red", "blue")
)
}
\arguments{
\item{parent.df}{data.frame used by ggplot}

\item{category.col}{data.frame column associated with categorical variable (bar.plot, box.plot, cdf.plot, dot.plot, km.plot)}

\item{category.label}{passed to x-axis label}

\item{response.col}{used by cdf.plottttt}

\item{x.label}{value gets passed to labs}

\item{x.limits}{value gets passed to scale_x_continuous}

\item{x.ticks}{value gets passed to scale_x_continuous}

\item{y.label}{value gets passed to labs}

\item{y.limits}{passed to scale_y_continuous}

\item{y.ticks}{passed to scale_y_continuous}

\item{line.size}{value gets passed to size within geom_line, geom_step}

\item{category.palette}{colors assoicated with categorical variable}
}
\value{
A ggplot object is returned.
}
\description{
A function for creating harmonized ggplot2 cumulative distribution plots. Statistics computed by stat_ecdf().
}
\examples{
{
data(demog.data)
cdf.plot(parent.df= demog.data, 
  category.col = "SEX",
  category.label   = "Gender",
  response.col = "BMI", 
  x.label = expression(paste("BMI (m/kg",phantom()^2,")")), 
  x.limits=c(0,60),
  x.ticks=seq(0,60,5),
  y.label = "Percentage of Subjects", 
  y.limits= c(0,1),
  y.ticks = seq(0,1,.2),
  line.size =.75,
  category.palette =c("red", "blue")
  )
}
}
\author{
Greg Cicconetti
}
