% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_import_nflfastr.R
\name{nflfastr_weekly}
\alias{nflfastr_weekly}
\title{Import latest nflfastr weekly stats}
\usage{
nflfastr_weekly(type = c("offense", "defense", "all"))
}
\arguments{
\item{type}{One of "offense", "defense", or "all" - currently, only "offense" is available.}
}
\value{
Weekly stats for all passers, rushers and receivers in the nflfastR play-by-play data from the 1999 season to the most recent season
}
\description{
Fetches a copy of the latest week-level stats from nflfastr's data repository.
The same output as nflfastr's load_player_stats() function.
}
\details{
The goal of this data is to replicate the NFL's official weekly stats, which
can diverge a bit from what fantasy data feeds display.

If you have any issues with the output of this data, please open an issue in
the nflfastr repository.
}
\examples{
\donttest{
nflfastr_weekly()
}

}
\seealso{
\url{https://nflfastr.com/reference/load_player_stats.html}
}
