% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{tidy_scores}
\alias{tidy_scores}
\title{Fantasy matchup scores}
\usage{
tidy_scores(leagueId = ffl_id(), leagueHistory = FALSE, useMatchup = TRUE, ...)
}
\arguments{
\item{leagueId}{Numeric league ID or ESPN fantasy page URL. Defaults to
\code{getOption("fflr.leagueId")}. Function fails if no ID is found.}

\item{leagueHistory}{logical; Should the \code{leagueHistory} version of the API
be called? If \code{TRUE}, a list of results is returned, with one element for
each historical year of the league.}

\item{useMatchup}{logical; Whether scoring should be summarized by
\code{matchupPeriodId} (default) or \code{scoringPeriodId}. The later always relates
to a single week of the NFL season, while fantasy matchups might span
several scoring periods, especially in the playoffs.}

\item{...}{Additional queries passed to \code{\link[httr:GET]{httr::GET()}}. Arguments are
converted to a named list and passed to \code{query} alongside \code{view}.}
}
\value{
A tidy data frame of scores by team and matchup/scoring period.
}
\description{
The score of each team in a matchup or scoring period and the match outcome.
}
\details{
\code{expectedWins} are calculated by comparing a team score against all \emph{other}
scores for a given matchup period. This statistic expresses how a team would
fair if the schedule was random The highest scoring team is thus expected to
earn 1 win and the lowest scoring team would expect to win 0 matchups.
}
\examples{
tidy_scores(leagueId = "42654852", useMatchup = FALSE)
}
\seealso{
Other scoring functions: 
\code{\link{live_scoring}()}
}
\concept{scoring functions}
