% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/live.R
\name{live_scoring}
\alias{live_scoring}
\title{Live matchup scoreboard}
\usage{
live_scoring(leagueId = ffl_id(), yetToPlay = FALSE, ...)
}
\arguments{
\item{leagueId}{Numeric league ID or ESPN fantasy page URL. Defaults to
\code{getOption("fflr.leagueId")}. Function fails if no ID is found.}

\item{yetToPlay}{If \code{TRUE}, \code{\link[=pro_schedule]{pro_schedule()}} and the "mRoster" view are
called to determine how many starting players have \emph{yet} started playing.}

\item{...}{Additional queries passed to \code{\link[httr:GET]{httr::GET()}}
(e.g., \code{scoringPeriodId}). Arguments are converted to a named list to be
passed alongside \code{view}.}
}
\value{
A data frame of scores by period.
}
\description{
The current and projected score for each ongoing match.
}
\examples{
live_scoring(leagueId = "42654852", yetToPlay = FALSE)
}
