% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_class.R
\docType{methods}
\name{kml,Fetch-method}
\alias{kml,Fetch-method}
\title{Write a Fetch object to a KML file}
\usage{
\S4method{kml}{Fetch}(obj,
  folder.name = normalizeFilename(deparse(substitute(obj, env =
  parent.frame()))),
  file.name = paste(normalizeFilename(deparse(substitute(obj, env =
  parent.frame()))), ".kml", sep = ""), overwrite = FALSE, ...)
}
\arguments{
\item{obj}{a \code{\link{Fetch}} object}

\item{folder.name}{character; folder name in the KML file}

\item{file.name}{character; output KML file name}

\item{overwrite}{logical; overwrite the existing file if one exists? Default
FALSE}

\item{...}{additional aesthetics arguments passed to
\code{\link[plotKML]{kml_layer.SpatialLines}}}
}
\description{
Write a \code{\link{Fetch}} object to a KML file. Various aesthetics
parameters can be set via \code{colour}, \code{alpha}, \code{size},
\code{shape} arguments.
}
