% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorial.R
\name{MCA}
\alias{MCA}
\title{Multiple Correspondence Analysis (MCA)}
\usage{
MCA(
  d,
  ncp = 5,
  ind.sup = NULL,
  quanti.sup = NULL,
  quali.sup = NULL,
  row.w = NULL
)
}
\arguments{
\item{d}{A ddata frame or a table with n rows and p columns, i.e. a contingency table.}

\item{ncp}{The number of dimensions kept in the results (by default 5).}

\item{ind.sup}{A vector indicating the indexes of the supplementary individuals.}

\item{quanti.sup}{A vector indicating the indexes of the quantitative supplementary variables.}

\item{quali.sup}{A vector indicating the indexes of the categorical supplementary variables.}

\item{row.w}{An optional row weights (by default, a vector of 1 for uniform row weights); the weights are given only for the active individuals.}
}
\value{
The MCA on the dataset.
}
\description{
Performs Multiple Correspondence Analysis (MCA) with supplementary individuals, supplementary quantitative variables and supplementary categorical variables.
Performs also Specific Multiple Correspondence Analysis with supplementary categories and supplementary categorical variables.
Missing values are treated as an additional level, categories which are rare can be ventilated.
}
\examples{
data (tea, package = "FactoMineR")
MCA (tea, quanti.sup = 19, quali.sup = 20:36)
}
\seealso{
\code{\link[FactoMineR]{MCA}}, \code{\link{CA}}, \code{\link{PCA}}, \code{\link{plot.factorial}}, \code{\link{factorial-class}}
}
