% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{getvocab}
\alias{getvocab}
\title{Extract words and phrases from a corpus}
\usage{
getvocab(corpus, mincount = 5, minphrasecount = NULL, ngram = 1,
  lang = "en", stopwords = lang, ...)
}
\arguments{
\item{corpus}{The corpus of documents (a vector of characters).}

\item{mincount}{Minimum word count to be considered as frequent.}

\item{minphrasecount}{Minimum collocation of words count to be considered as frequent.}

\item{ngram}{maximum size of n-grams.}

\item{lang}{The language of the documents (NULL if no stemming).}

\item{stopwords}{Stopwords, or the language of the documents. NULL if stop words should not be removed.}

\item{...}{Other parameters.}
}
\value{
The vocabulary used in the corpus of documents.
}
\description{
Extract words and phrases from a corpus of documents.
}
\examples{
\dontrun{
text = loadtext ("http://mattmahoney.net/dc/text8.zip")
vocab1 = getvocab (text) # With stemming
nrow (vocab1)
vocab2 = getvocab (text, lang = NULL) # Without stemming
nrow (vocab2)
}
}
\seealso{
\code{\link{plotzipf}}, \code{\link[stopwords]{stopwords}}, \code{\link[text2vec]{create_vocabulary}}
}
