% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFinancials.R
\name{getFinancials}
\alias{getFinancials}
\title{Get financial data for a given institution}
\usage{
getFinancials(IDRSSD_or_CERT, metrics, limit = 1, IDRSSD = TRUE, range = NULL)
}
\arguments{
\item{IDRSSD_or_CERT}{Numeric value indicating the IDRSSD or CERT number of the institution to retrieve data for.}

\item{metrics}{Vector of metric names to retrieve financial data for.}

\item{limit}{Number of records to retrieve.}

\item{IDRSSD}{Boolean value indicating whether IDRSSD (True) or CERT number (False) is used.}

\item{range}{Character vector contains start and end date for range. Open ended ranges can be expressed using a "*"}
}
\value{
A dataframe containing the requested financial data.
}
\description{
This function retrieves financial data for a given institution from the FDIC API.
}
\examples{
getFinancials(37, metrics = c("ASSET", "DEP"),limit = 10, range = c("2015-01-01","*"))
getFinancials(37, metrics = c("ASSET", "DEP"),limit = 10, range = c("2015-01-01","2016-01-01"))
}
