% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refactoring.R
\name{get_l2_inner_product}
\alias{get_l2_inner_product}
\title{Computes the \eqn{L^2} inner product between two SRVFs}
\usage{
get_l2_inner_product(q1fun, q2fun)
}
\arguments{
\item{q1fun}{A function that takes a numeric vector \eqn{s} of values in
\eqn{[0, 1]} as input and returns the values of the first SRVF at \eqn{s}.}

\item{q2fun}{A function that takes a numeric vector \eqn{s} of values in
\eqn{[0, 1]} as input and returns the values of the second SRVF at \eqn{s}.}
}
\value{
A numeric value storing the \eqn{L^2} inner product between the two
SRVFs.
}
\description{
Computes the \eqn{L^2} inner product between two SRVFs
}
\examples{
q1 <- curve2srvf(beta[, , 1, 1])
q2 <- curve2srvf(beta[, , 1, 2])
get_l2_inner_product(q1, q2)
}
