% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caps-class.R
\name{caps}
\alias{caps}
\alias{as_caps}
\alias{is_caps}
\title{Class for clustering with amplitude and phase separation}
\usage{
as_caps(x)

is_caps(x)
}
\arguments{
\item{x}{A list coercible into an object of class \code{\link{caps}}.}
}
\value{
The function \code{\link[=as_caps]{as_caps()}} returns an object of class \code{\link{caps}}. The
function \code{\link[=is_caps]{is_caps()}} returns a boolean which evaluates to \code{TRUE} is the
input object is of class \code{\link{caps}}.
}
\description{
The k-means algorithm with joint amplitude and phase separation produces a
number of outputs. This class is meant to encapsulate them into a single
object for providing dedicated \code{S3} methods for e.g. plotting, summarizing,
etc. The name of the class stems from \strong{C}lustering with \strong{A}mplitude and
\strong{P}hase \strong{S}eparation.
}
\details{
An object of class \code{\link{caps}} is a list with the following components:
\itemize{
\item \code{original_curves}: A numeric matrix of shape \eqn{N \times L \times M}
storing a sample with the \eqn{N} \eqn{L}-dimensional original curves
observed on grids of size \eqn{M}.
\item \code{aligned_curves}: A numeric matrix of shape \eqn{N \times L \times M}
storing a sample with the \eqn{N} \eqn{L}-dimensional aligned curves observed
on grids of size \eqn{M}.
\item \code{center_curves}: A numeric matrix of shape \eqn{K \times L \times M}
storing the \eqn{K} centers which are \eqn{L}-dimensional curves observed on
a grid of size \eqn{M};
\item \code{warpings}: A numeric matrix of shape \eqn{N \times M} storing the
estimated warping functions for each of the \eqn{N} curves evaluated on the
within-cluster common \code{grids} of size \eqn{M};
\item \code{grids}: A numeric matrix of size \eqn{K \times M} storing the
within-cluster common grids of size \eqn{M} on which curves are evaluated;
\item \code{n_clusters}: An integer value storing the number of clusters;
\item \code{memberships}: An integer vector of length \eqn{N} storing the cluster ID
which each curve belongs to;
\item \code{distances_to_center}: A numeric vector of length \eqn{N} storing the
distance of each curve to the center of its cluster;
\item \code{silhouettes}: A numeric vector of length \eqn{N} storing the silhouette
values of each observation;
\item \code{n_iterations}: An integer value storing the number of iterations
performed until convergence;
\item \code{call_name}: A string storing the name of the function that was used to
produce the k-means alignment results;
\item \code{call_args}: A list containing the exact arguments that were passed to
the function \code{call_name} that produced this output.
}
}
\examples{
as_caps(sim30_caps)
is_caps(sim30_caps)
}
