% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsing_and_conversion.R
\name{reactiontbl_to_expanded}
\alias{reactiontbl_to_expanded}
\title{Parse a reaction table to an intermediate, long format}
\usage{
reactiontbl_to_expanded(reaction_table, regex_arrow = "<?[-=]+>")
}
\arguments{
\item{reaction_table}{A data frame describing the metabolic model.}

\item{regex_arrow}{Regular expression for the arrow splitting sides of the reaction equation.}
}
\value{
A list of data frames: \itemize{
  \item \code{rxns}, which has one row per reaction, 
  \item \code{mets}, which has one row for each metabolite, and 
  \item \code{stoich}, which has one row for each time a metabolite appears in a reaction.
}
}
\description{
The long format can also be suitable for manipulating equations.
}
\details{
The \code{reaction_table} must have columns:
\itemize{
 \item \code{abbreviation},
 \item \code{equation},
 \item \code{uppbnd},
 \item \code{lowbnd}, and
 \item \code{obj_coef}.
}
}
\examples{

\dontrun{
data(ecoli_core)
library(dplyr)
try(library(ROI.plugin.ecos)) # make a solver available to ROI

roi_model <- ecoli_core \%>\%
  reactiontbl_to_expanded \%>\%
  expanded_to_ROI
  
if(length(ROI::ROI_applicable_solvers(roi_model))>=1){
  roi_result <- ROI::ROI_solve(roi_model)
  
  ecoli_core_with_flux <- ecoli_core \%>\%
    mutate(flux = roi_result[['solution']])
}
}
}
\seealso{
Other parsing_and_conversion: \code{\link{expanded_to_ROI}},
  \code{\link{expanded_to_glpk}},
  \code{\link{expanded_to_gurobi}},
  \code{\link{reactiontbl_to_gurobi}}
}
\concept{parsing_and_conversion}
