% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fb_init.R
\name{fbad_init}
\alias{fbad_init}
\title{Initiate Facebook Account with OAuth token}
\usage{
fbad_init(accountid, token, version = fb_api_most_recent_version())
}
\arguments{
\item{accountid}{Facebook Ad account id without the \code{act_} prefix}

\item{token}{Facebook OAuth token as a string}

\item{version}{Facebook Marketing API version}
}
\value{
list returned invisibly containing versioned base URL and relevant API parameters
}
\description{
If you do not have a token, then register an (e.g. "Website") application at \url{https://developers.facebook.com/apps} and make a note of your "App ID" and "App Secret" at the "Dashboard" of your application. Then go to "Settings", click on "Add Platform", then "Website" and paste \code{http://localhost:1410} as the "Site URL". Save, and then run the below example R commands to get your token. Please note that your app needs access to your ads as well, see \url{https://developers.facebook.com/docs/marketing-api/access} for more details.
}
\examples{
\dontrun{
## You can generate a token for future use with the help of `httr`, e.g.
library(httr)
app <- oauth_app("facebook", your_app_id,  your_app_secret)
oauth2.0_token(oauth_endpoints("facebook"), app,
  scope = '',
  type  = "application/x-www-form-urlencoded")$credentials$access_token

## Then pass this token with your account ID to fbad_init
}
}

