% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API.R
\name{predict.Rcpp_fastrtext}
\alias{predict.Rcpp_fastrtext}
\title{Get predictions (for supervised model)}
\usage{
\method{predict}{Rcpp_fastrtext}(object, sentences, k = 1,
  simplify = FALSE, unlock_empty_predictions = FALSE, threshold = 0,
  ...)
}
\arguments{
\item{object}{trained \code{fastText} model}

\item{sentences}{\link{character} containing the sentences}

\item{k}{will return the \code{k} most probable labels (default = 1)}

\item{simplify}{when \link{TRUE} and \code{k} = 1, function return a (flat) \link{numeric} instead of a \link{list}}

\item{unlock_empty_predictions}{\link{logical} to avoid crash when some predictions are not provided for some sentences because all their words have not been seen during training. This parameter should only be set to \link{TRUE} to debug.}

\item{threshold}{used to limit number of words used. (optional; 0.0 by default)}

\item{...}{not used}
}
\value{
\link{list} containing for each sentence the probability to be associated with \code{k} labels.
}
\description{
Apply the trained  model to new sentences.
Average word embeddings and search most similar \code{label} vector.
}
\examples{

library(fastrtext)
data("test_sentences")
model_test_path <- system.file("extdata", "model_classification_test.bin", package = "fastrtext")
model <- load_model(model_test_path)
sentence <- test_sentences[1, "text"]
print(predict(model, sentence))

}
