% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction_strength.R
\name{interaction_strength}
\alias{interaction_strength}
\title{Compute feature interaction strengths for a fastml model}
\usage{
interaction_strength(object, ...)
}
\arguments{
\item{object}{A `fastml` object.}

\item{...}{Additional arguments passed to `iml::Interaction`.}
}
\value{
An `iml::Interaction` object.
}
\description{
Uses the `iml` package to quantify the strength of feature interactions.
}
\examples{
\dontrun{
data(iris)
iris <- iris[iris$Species != "setosa", ]
iris$Species <- factor(iris$Species)
model <- fastml(data = iris, label = "Species")
interaction_strength(model)
}
}
