% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_models.R
\name{train_models}
\alias{train_models}
\title{Train Specified Machine Learning Algorithms on the Training Data}
\usage{
train_models(
  train_data,
  label,
  task,
  algorithms,
  resampling_method,
  folds,
  repeats,
  resamples = NULL,
  tune_params,
  metric,
  summaryFunction = NULL,
  seed = 123,
  recipe,
  use_default_tuning = FALSE,
  tuning_strategy = "grid",
  tuning_iterations = 10,
  early_stopping = FALSE,
  adaptive = FALSE,
  algorithm_engines = NULL
)
}
\arguments{
\item{train_data}{Preprocessed training data frame.}

\item{label}{Name of the target variable.}

\item{task}{Type of task: "classification" or "regression".}

\item{algorithms}{Vector of algorithm names to train.}

\item{resampling_method}{Resampling method for cross-validation (e.g., "cv", "repeatedcv", "boot", "none").}

\item{folds}{Number of folds for cross-validation.}

\item{repeats}{Number of times to repeat cross-validation (only applicable for methods like "repeatedcv").}

\item{resamples}{Optional rsample object. If provided, custom resampling splits
will be used instead of those created internally.}

\item{tune_params}{A named list of tuning ranges. For each algorithm, supply a
list of engine-specific parameter values, e.g.
\code{list(rand_forest = list(ranger = list(mtry = c(1, 3)))).}}

\item{metric}{The performance metric to optimize.}

\item{summaryFunction}{A custom summary function for model evaluation. Default is \code{NULL}.}

\item{seed}{An integer value specifying the random seed for reproducibility.}

\item{recipe}{A recipe object for preprocessing.}

\item{use_default_tuning}{Logical; if \code{TRUE} and \code{tune_params} is \code{NULL}, tuning is performed using default grids. Tuning also occurs when custom \code{tune_params} are supplied. When \code{FALSE} and no custom parameters are given, the model is fitted once with default settings.}

\item{tuning_strategy}{A string specifying the tuning strategy. Must be one of
\code{"grid"}, \code{"bayes"}, or \code{"none"}. Adaptive methods may be
used with \code{"grid"}. If \code{"none"} is selected, the workflow is fitted
directly without tuning.
If custom \code{tune_params} are supplied with \code{tuning_strategy = "none"},
they will be ignored with a warning.}

\item{tuning_iterations}{Number of iterations for Bayesian tuning. Ignored
when \code{tuning_strategy} is not \code{"bayes"}; validation occurs only
for the Bayesian strategy.}

\item{early_stopping}{Logical for early stopping in Bayesian tuning.}

\item{adaptive}{Logical indicating whether to use adaptive/racing methods.}

\item{algorithm_engines}{A named list specifying the engine to use for each algorithm.}
}
\value{
A list of trained model objects.
}
\description{
Trains specified machine learning algorithms on the preprocessed training data.
}
