% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpb.R
\name{hpb}
\alias{hpb}
\title{H+ discordance estimation with bootstrapping}
\usage{
hpb(D, L, r = 30, t)
}
\arguments{
\item{D}{numeric matrix or data frame with observations in rows (nxm)}

\item{L}{numeric vector containing a set of length n}

\item{r}{numeric number of bootstrap iterations}

\item{t}{numeric  pre-bootstrap sample size, 1-5\% of n}
}
\value{
list, h is the estimated H+ value.

gamma1 and gamma2 are plausible ranges for what \% of A (or Dw)

are strictly greater than B (or Db)
}
\description{
Estimates the H+ discordance metric
given data Dat and a label vector L.
Bootstrapping is performed over r iterations with s points sampled per iterate.
}
\examples{
a <- sapply(1:500, function(i) rnorm(n=50, mean=0))
b <- sapply(1:500, function(i) rnorm(n=50, mean=0))
x <- t(cbind(a,b))
l <- c(rep(0,500), rep(1,500))
h <- hpb(D=x, L=l, r=30,t=50)

}
