% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hillshade.r
\name{hillshade,GRaster-method}
\alias{hillshade,GRaster-method}
\alias{hillshade}
\title{Hillshading}
\usage{
\S4method{hillshade}{GRaster}(x, angle = 45, direction = 0, zscale = 1)
}
\arguments{
\item{x}{A \code{GRaster} (typically representing elevation).}

\item{angle}{Numeric: The altitude of the sun above the horizon in degrees. Valid values are in the range [0, 90], and the default value is 45 (half way from the horizon to overhead).}

\item{direction}{The direction (azimuth) in which the sun is shining in degrees. Valid values are in the range 0 to 360. The default is 0, meaning the sun is at due south (180 degrees) and shining due north (0 degrees). Note that in this function, 0 corresponds to north and 180 to south, but in the \strong{GRASS} module \code{r.relief}, "east orientation" is used (0 is east, 90 is north, etc.).}

\item{zscale}{Numeric: Value by which to exaggerate terrain. The default is 1.  Numbers greater than this will increase apparent relief, and less than this (even negative) will diminish it.}
}
\value{
A \code{GRaster}.
}
\description{
Hillshade rasters are often used for display purposes because they make topographical relief look "real" to the eye.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Example data
madElev <- fastData("madElev")

# Convert a SpatRaster to a GRaster
elev <- fast(madElev)

# Calculate all topographic metrics
topos <- terrain(elev, v = "*")
topos

plot(topos) # NB Aspect has values of NA when it cannot be defined

# Calculate a hillshade raster
hs <- hillshade(elev)
plot(hs)

}
}
