% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00e_GVector_class.r
\name{.makeGVector}
\alias{.makeGVector}
\title{Create a GVector}
\usage{
.makeGVector(
  src,
  table = NULL,
  build = TRUE,
  extensive = FALSE,
  cats = NULL,
  fail = TRUE
)
}
\arguments{
\item{src}{Character: The name of the vector in \strong{GRASS}.}

\item{table}{A \code{data.table}, \code{data.frame}, \code{GVector} with a table, or character. This can be \code{data.table(NULL)} or \code{data.frame(NULL)} if there is no table associated with the vector. If a character, this is interpreted as the name of the table in \strong{GRASS}.}

\item{build}{Logical: If \code{TRUE} (default), build topology using \strong{GRASS} module \code{v.build}.}

\item{extensive}{Logical: If \code{TRUE}, do extensive topological checks using \code{v.build}. The default is \code{FALSE}.}

\item{cats}{\code{NULL} (default) or an integer vector: Values of the "cats" (categories) of the vector in \strong{GRASS}. This is useful \emph{only} for speeding up the \code{GVector} creation process when the "cats" have already been ascertained.}

\item{fail}{Logical: If \code{TRUE} (default), and the vector either has a 0 east-west or north-south extent, then exit the function with an error. If \code{fail} is \code{FALSE}, then display a warning and return \code{NULL}.}
}
\value{
A \code{GVector} (or \code{NULL} if \code{fail} is \code{TRUE} and the \code{GVector} would be invalid).
}
\description{
Create a \code{GVector} from a vector existing in the current \strong{GRASS} session.
}
\seealso{
\code{\link[=.makeGRaster]{.makeGRaster()}}
}
\keyword{internal}
