% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterPoints.r
\name{clusterPoints,GVector-method}
\alias{clusterPoints,GVector-method}
\alias{clusterPoints}
\title{Identify clusters of points}
\usage{
\S4method{clusterPoints}{GVector}(x, method = "DBSCAN", minIn = NULL, maxDist = NULL)
}
\arguments{
\item{x}{A "points" \code{GVector}.}

\item{method}{Character: Method used to identify clusters. Explanations of methods are provided in the help page for the \strong{GRASS} module \code{v.cluster}, available using \code{grassHelp("v.cluster")}.
\itemize{
\item \code{"DBSCAN"} (default): Density-Based Spatial Clustering of Applications with Noise.
\item \code{"DBSCAN2"}: A modification of DBSCAN.
\item \code{"density"}: Cluster points by relative density.
\item \code{"OPTICS"}: Ordering Points to Identify the Clustering Structure
\item \code{"OPTICS2"}: A modification of OPTICS.
}

Case is ignored, but partial matching is not used.}

\item{minIn}{Integer, numeric integer, or \code{NULL} (default): Minimum number of points in a cluster. If \code{NULL}, then \code{minIn} is set to 3 for a 2-dimensional vector and 4 for a 3-dimensional vector.}

\item{maxDist}{Numeric or \code{NULL} (default): Maximum distance between neighboring points in a cluster for DBSCAN, DBSCAN2, and OPTICS. If \code{NULL}, the maximum distance will be set to the 99th quantile of observed pairwise distances between points.}
}
\value{
A vector of integers indicating the cluster to which each point belongs.
}
\description{
\code{clusterPoints()} partitions points in a "points" \code{GVector} into clusters.
}
\seealso{
\strong{GRASS} manual page for module \code{v.cluster} (see \code{grassHelp("v.cluster")})
}
