% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replaceNAs.r
\name{replaceNAs,data.frame-method}
\alias{replaceNAs,data.frame-method}
\alias{replaceNAs}
\alias{replaceNAs,matrix-method}
\alias{replaceNAs,data.table-method}
\alias{replaceNAs,numeric-method}
\alias{replaceNAs,integer-method}
\alias{replaceNAs,logical-method}
\alias{replaceNAs,character-method}
\title{Replace NAs in a data.table or data.frame column, or in a vector}
\usage{
\S4method{replaceNAs}{data.frame}(x, replace, cols = NULL)

\S4method{replaceNAs}{matrix}(x, replace, cols = NULL)

\S4method{replaceNAs}{data.table}(x, replace, cols = NULL)

\S4method{replaceNAs}{numeric}(x, replace)

\S4method{replaceNAs}{integer}(x, replace)

\S4method{replaceNAs}{logical}(x, replace)

\S4method{replaceNAs}{character}(x, replace)
}
\arguments{
\item{x}{A \code{data.table} or \code{data.frame} or \code{matrix}, or a vector of numeric, integer, logical, or character values.}

\item{replace}{A value of any atomic class (numeric, integer, character, Date, etc.): Value to to replace \code{NA}s.}

\item{cols}{\code{NULL}, character, numeric, integer, or logical vector: Indicates columns for which to replace \code{NA}s. If \code{NULL}, then all columns will have \code{NA}s replaced. If a character, this is the column name(s). If numeric or integer, this is the columns' indices. If logical, columns with \code{TRUE} have \code{NA}s replaced. If a logical vector has fewer than the total number of columns, it will be recycled.}
}
\value{
A \code{data.table}, \code{data.frame}, \code{matrix}, or vector.
}
\description{
This function replaces \code{NA}s in one or more \code{data.table}, \code{data.frame}, or \code{matrix} columns, or in vectors, with a user-defined value.
}
\examples{

library(data.table)

dt <- data.table(
   x = 1:10,
   y = letters[1:10],
   z = rnorm(10)
)

# make some values NA
dt[x == 4 | x == 8, y := NA_character_]
dt

# Replace NAs:
replaceNAs(dt, replace = -99, cols = "y")
dt

# Drop rows:
dropped <- dropRows(dt, 8:10)
dropped

# NB May not print... in that case, use:
print(dropped)

# We can also use replaceNAs() on vectors:
y <- 1:10
y[c(2, 10)] <- NA
replaceNAs(y, -99)

# Same as:
y <- 1:10
y[c(2, 10)] <- NA
y[is.na(y)] <- -99
}
