% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd.poisson}
\alias{fastcpd.poisson}
\alias{fastcpd_poisson}
\title{Find change points efficiently in Poisson regression models}
\usage{
fastcpd.poisson(data, ...)

fastcpd_poisson(data, ...)
}
\arguments{
\item{data}{A matrix or a data frame with the response variable as the first
column.}

\item{...}{Other arguments passed to \code{\link{fastcpd}}, for example,
\code{segment_count}.}
}
\value{
A class \code{fastcpd} object.
}
\description{
\code{"fastcpd_poisson"} and \code{"fastcpd.poisson"} are
wrapper functions of \code{\link{fastcpd}} to find change points in
Poisson regression models. The function is similar to \code{"fastcpd"}
except that the data is by default a matrix or data frame with the response
variable as the first column and thus a formula is not required here.
}
\examples{
\donttest{
set.seed(1)
n <- 1100
p <- 3
x <- mvtnorm::rmvnorm(n, rep(0, p), diag(p))
delta <- rnorm(p)
theta_0 <- c(1, 1.2, -1)
y <- c(
  rpois(300, exp(x[1:300, ] \%*\% theta_0)),
  rpois(400, exp(x[301:700, ] \%*\% (theta_0 + delta))),
  rpois(300, exp(x[701:1000, ] \%*\% theta_0)),
  rpois(100, exp(x[1001:n, ] \%*\% (theta_0 - delta)))
)
result <- suppressWarnings(
  fastcpd.poisson(cbind(y, x), epsilon = 1e-5, k = function(x) 1)
)
summary(result)
plot(result)
}
}
