% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnb.detect_distribution.R
\name{fnb.detect_distribution}
\alias{fnb.detect_distribution}
\alias{fnb.detect_distribution.default}
\title{Distribution Detection Function}
\usage{
fnb.detect_distribution(x, nrows = nrow(x))

\method{fnb.detect_distribution}{default}(x, nrows = nrow(x))
}
\arguments{
\item{x}{a numeric matrix, or a dgcMatrix}

\item{nrows}{number of rows to use to detect distributions}

\item{...}{Not used.}
}
\value{
A list of distribution names mapped to column names
}
\description{
Determines which distribution to use for which columns in the matrix based
on a set of rules.
}
\details{
A simple utility function to detect the distribution to use for each columns
}
\examples{
rm(list = ls())
library(fastNaiveBayes)
cars <- mtcars
y <- as.factor(ifelse(cars$mpg > 25, "High", "Low"))
x <- cars[, 2:ncol(cars)]

# Uses default of all rows to determine distributions
dist <- fnb.detect_distribution(x)
print(dist)

# Uses top 10 rows of x to determine distributions. If top 10 rows
# are representative this is can be much faster.
dist <- fnb.detect_distribution(x, nrows = 10)
print(dist)
}
