% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastMatMR-package.R
\name{fmm_to_sparse_Matrix}
\alias{fmm_to_sparse_Matrix}
\title{Convert Matrix Market File to Sparse Matrix}
\usage{
fmm_to_sparse_Matrix(filename)
}
\arguments{
\item{filename}{The name of the input Matrix Market file to be read.}
}
\value{
A dgCMatrix object containing the data read from the Matrix Market
file.
}
\description{
This function reads a Matrix Market file and converts it to a
sparse matrix in R using the Matrix package.
}
\examples{
# Create
sample_sparse_mat <- Matrix::Matrix(c(1, 0, 0, 2), nrow = 2, sparse = TRUE)
temp_file <- tempfile(fileext = ".mtx")
write_fmm(sample_sparse_mat, temp_file)
# Read
sparse_mat <- fmm_to_sparse_Matrix(temp_file)
}
