% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate.R
\name{truncate}
\alias{truncate}
\title{Truncate a vector.}
\usage{
truncate(x, prob = 0.01, p_low = prob, p_high = 1 - prob)
}
\arguments{
\item{x}{A vector to be winsorized}

\item{prob}{Level (two-sided) for winsorization (e.g., 0.01 gives 1\% and 99\%)}

\item{p_low}{Optional lower level for winsorization (e.g., 0.01 gives 1\%)}

\item{p_high}{Optional upper level for winsorization (e.g., 0.99 gives 99\%)}
}
\value{
vector
}
\description{
Truncate a vector at prob and 1 - prob.
Extreme values are turned in NA values.
}
\examples{
trunced <- truncate(1:100, prob = 0.05)
min(trunced, na.rm = TRUE)
max(trunced, na.rm = TRUE)
}
