% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ceteris_paribus_cutoff.R
\name{plot.ceteris_paribus_cutoff}
\alias{plot.ceteris_paribus_cutoff}
\title{Ceteris paribus cutoff plot}
\usage{
\method{plot}{ceteris_paribus_cutoff}(x, ...)
}
\arguments{
\item{x}{ceteris_paribus_cutoff object}

\item{...}{other plot parameters}
}
\value{
\code{ggplot2} object
}
\description{
Ceteris paribus cutoff is way to check how will parity loss behave if we changed only cutoff in one subgroup.
It plots object of class ceteris_paribus_cutoff. It might have two types - default and cumulated. Cumulated sums metrics and plots
it all in one plot. When default one is used all chosen metrics will be plotted for each model.
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           num.trees = 200)

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
                          protected = german$Sex,
                          privileged = "male")

cpc <- ceteris_paribus_cutoff(fobject, "female")
plot(cpc)

cpc <- ceteris_paribus_cutoff(fobject, "female", cumulated = TRUE)
plot(cpc)

}
