% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat_model.R
\name{mat.model.base}
\alias{mat.model.base}
\title{matrix population model}
\usage{
mat.model.base(n = 3, Ds = runif(n, 0, 5), Gs = runif(n - 1, 0, 5),
  Rs = runif(n, 0, 5))
}
\arguments{
\item{n}{The number of life stages. Default is 3.}

\item{Ds}{An n-array with death rates for each stage.}

\item{Gs}{An (n-1)-array with growth rates for each stage but the last.}

\item{Rs}{Either a single reproduction rate for the oldest stage, or an n-array of reproduction rates for each stage.}
}
\description{
Produces the Matrix Population Model matrix for a continuous time structured
population model, to be applied in a linear ODE. Unlike \code{\link{mat.model.base}}, only
works with a single population. If only the number of stages is provided, returns a ramdom
population matrix.
}
\examples{
mat <- mat.model.base(5)
mat2 <- mat.model.base(3,c(1,2,3),c(10,10),100)
}
