% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm.R
\name{refit.TSLM}
\alias{refit.TSLM}
\title{Refit a \code{TSLM}}
\usage{
\method{refit}{TSLM}(object, new_data, specials = NULL, reestimate = FALSE, ...)
}
\arguments{
\item{object}{The time series model used to produce the forecasts}

\item{new_data}{A \code{tsibble} containing future information used to forecast.}

\item{specials}{(passed by \code{\link[fabletools:forecast]{fabletools::forecast.mdl_df()}}).}

\item{reestimate}{If \code{TRUE}, the coefficients for the fitted model will be re-estimated to suit the new data.}

\item{...}{Additional arguments for forecast model methods.}
}
\description{
Applies a fitted \code{TSLM} to a new dataset.
}
\examples{
lung_deaths_male <- as_tsibble(mdeaths)
lung_deaths_female <- as_tsibble(fdeaths)

fit <- lung_deaths_male \%>\%
  model(TSLM(value ~ trend() + season()))

report(fit)

fit \%>\%
  refit(lung_deaths_female) \%>\%
  report()
}
