% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.net.R
\name{est.net}
\alias{est.net}
\title{Sparse network estimation using non-negative matrix factorization (NMF) for data between change points}
\usage{
est.net(Y, nruns = 50, lambda = 7, rank = "optimal", algtype = "brunet")
}
\arguments{
\item{Y}{A numerical matrix representing the multivariate time series, with the columns representing its components.}

\item{nruns}{A positive integer with default value equal to 50. It is used to define the number of runs in the NMF function.}

\item{lambda}{A positive real number, which defines the clustering method and/or the cutoff value when estimating an adjacency matrix from the computed
consensus matrix. If lambda = a positive integer value, say 6, complete-linkage, hierarchical clustering is applied to the consensus matrix and the cutoff is at
6 clusters. If lambda = a positive real number, say 0.5, entries in the consensus matrix with a value greater than or equal to 0.5 are labelled 1,
while entries less than 0.5 are labelled 0.}

\item{rank}{A character string or a positive integer, which defines the rank used in the optimization procedure to detect the change points.
If rank = "optimal", which is also the default value, then the optimal rank is used. If rank = a positive integer value, say 4, then a predetermined
rank is used.}

\item{algtype}{A character string, which defines the algorithm to be used in the NMF function. By default it is set to "brunet". See the "Algorithms" section of
\code{\link[NMF]{nmf}} for more information on the available algorithms.}
}
\value{
A matrix (or more specifically, an adjacency matrix) denoting the network (or clustering) structure between components of \eqn{Y}.
}
\description{
This function estimates sparse networks using non-negative matrix factorization (NMF) for data between change points.
}
\examples{
## Estimating the network for a multivariate data set, "sim2" using default settings
\donttest{est.net(sim2)}

## Estimating the network for a multivariate data set, "sim2", using hierarchical
## clustering to generate the adjacency matrix with a cutoff value of 7 clusters
\donttest{est.net(sim2, nruns = 100, lambda = 7)}

## Estimating the network for a multivariate data set, "sim2", and using a cutoff
## value for the adjacency matrix to enforce sparsity, where the cutoff is 0.5
\donttest{est.net(sim2, nruns = 100, lambda = 0.5)}

## Estimating the network for a multivariate data set, "sim2"
\donttest{est.net(sim2, rank = 4)}

## Estimating the network for a multivariate data set, "sim2", using the "snmf/l"
## algorithm for NMF
\donttest{est.net(sim2, algtype = "snmf/l")}

}
\references{
"Factorized Binary Search: a novel technique for change point detection in multivariate high-dimensional time series networks", Ondrus et al.
(2021), preprint.
}
\author{
Martin Ondrus, \email{mondrus@ualberta.ca}, Ivor Cribben, \email{cribben@ualberta.ca}
}
