% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-viz.R
\name{plot_main_word}
\alias{plot_main_word}
\title{Draw bar plot of one (possibly grouped) open-text column in a tibble}
\usage{
plot_main_word(
  tbl = "iris",
  col = "Species",
  filter = "c()",
  negate = FALSE,
  missing_values = "c()",
  max = 10,
  out = "ggplot2-cat",
  group_by = NULL
)
}
\arguments{
\item{tbl}{A character string or tibble specifying the input tibble}

\item{col}{A character string specifying a column of interest}

\item{filter}{A character string specifying the values to filter. (equivalent
to 'values in') This determines which values should be retained. It can be
applied to both grouped and ungrouped data.}

\item{negate}{If TRUE, return non-matching elements.}

\item{missing_values}{Vector listing values to exclude from valid values.
These values will not be excluded from counting - but will be displayed
separately from valid values.}

\item{max}{integer specifying the x-th first most cited words}

\item{out}{parameter that specifies the output expected: can be either
'ggplot2', 'plotly','ggplot2-code', 'plotly-code','ggplot2-cat' or
'plotly-cat'. ggplot2 renders a static plot, plotly a dynamic plot, code
gives the code in a string (usable directly with eval/parse functions) and
cat provides indented code in the console.}

\item{group_by}{A character string of one column in the tbl that can be
taken as a grouping column. The visual element will be grouped and displayed
by this column.}
}
\value{
A bar plot object
}
\description{
This function draws a bar plot of the values of open text column. This
plot shows the x-th first most cited words in a column having open text
values using tidytext library.
Missing values can be given as input to non-valid and valid values
separately, or grouped by another column. The output can be editable (using
plotly library) or static (using ggplot2 library). The R-code is also
editable for coding recycling purpose.
}
\examples{
{

##### Example 1 -------------------------------------------------------------
# cat output generated as a template when no argument provided
plot_main_word()

##### Example 2 -------------------------------------------------------------
# words contained in Species
plot_main_word(tbl = "iris", col = "Species", out = "ggplot2")

}

}
\seealso{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
