% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_plot.R
\name{side_plot}
\alias{side_plot}
\title{side_plot}
\usage{
side_plot(
  data,
  x,
  y = "1",
  labels_y = ez_labels,
  size = 11,
  palette = ez_col,
  signif = 3,
  reorder = TRUE,
  rescale_y = 1.25
)
}
\arguments{
\item{data}{A data.frame.}

\item{x}{A named character value. Evaluates to a column.}

\item{y}{A named character value. Evaluates to a column.}

\item{labels_y}{label formatting function}

\item{size}{theme size for \code{use_theme()}. Default is 14.}

\item{palette}{Colour function.}

\item{signif}{Number of significant digits.}

\item{reorder}{A character vector specifying the group variables to reorder.
Default is \code{c("group", "facet_x", "facet_y")}.}

\item{rescale_y}{Rescaling factor for y-axis limits}
}
\description{
side_plot
}
\examples{
side_plot(mtcars, "gear", "1")
side_plot(mtcars, "cyl", c("Cars with <120 HP" = "hp < 120"))
side_plot(mtcars, "cyl", c(count = "ifelse(cyl == 4, 1, -1)", "hp <= 120"))
side_plot(mtcars, "cyl", c("hp <= 120", "~ - wt / cyl"))
side_plot(mtcars, "cyl", c("1", "-1"))
}
