% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_exvadec.R
\name{make_exvadec}
\alias{make_exvadec}
\title{Decomposition of value added in exports using different methodologies}
\usage{
make_exvadec(
  wio_object,
  exporter = "all",
  method = "bm_src",
  output = "standard",
  quiet = FALSE,
  ...
)
}
\arguments{
\item{wio_object}{An object of class \code{wio} (standardized world
input-output table) obtained using \code{\link[=make_wio]{make_wio()}}.}

\item{exporter}{String with a country or a country group code
(e.g., \code{"USA"}, code{"NAFTA"}, etc.). The default \code{"all"}
produces the decomposition of value added in exports for all
available individual countries.}

\item{method}{A string specifying the export VA decomposition method:
\itemize{
\item \code{"bm_src"}: Borin and Mancini, source-based (2019) (default).
\item \code{"bm_snk"}: Borin and Mancini, sink-based (2019).
\item \code{"wwz"}: Wang et al. (2013).
\item \code{"kww"}: Koopman et al. (2014).
\item \code{"kww"}: Miroudot and Ye (2021)
\item \code{"oecd"}: OECD (not properly a decomposition).
}}

\item{output}{Type of matrices in output:
\itemize{
\item \code{"standard"} (default): Shows the domestic content (\code{DC}),
domestic value added (\code{DVA}), the domestic double counting
(\code{DDC}), the foreign content (\code{FC}), the foreign value
added (\code{FVA}) and the foreign double counting (\code{DDC}). The
value added exported (\code{VAX}) is also produced in most cases, and
additional indicators are provided in specific cases.
\item \code{"terms"}: Shows the basic decomposition terms, whose sum gives
the value of gross exports. The number and specification of terms
follows the standard in the economic literature: 12 in the Borin and
Mancini (2019) decompositions (source and sink), 16 in the Wang et al.
(2013) decomposition, 9 in the Koopman et al. (2014) decomposition
and just 4 in the Miroudot and Ye (2021) decomposition (as the latter
does not expand value added in terms of final absorption, like the
rest). \
For the \code{"wwz"} (Wang et al. ,2013) decomposition there is an
additional \code{"terms2"} option with an alternative arrangement of
terms, and for the \code{"oecd"} decomposition there is an
additional \code{"tiva"} decomposition with many TiVA basic indicators.
}}

\item{quiet}{Boolean, if \code{TRUE} suppress all status messages. Default
is \code{FALSE}, i.e., messages are shown.}

\item{...}{Additional parameters for the Miroudot and Ye (2021)
decomposition. These can be:
\itemize{
\item \code{perim} String, for general perimeter of value added.
Default is \code{"country"}, but can also be \code{"WLD"} (world). In
this case, all flows that cross the border of \emph{any} country
more than once will be considered as double counting (unlike in the
country perspective, where flows are considered as double counting
only when they \emph{exit} the border of \emph{the exporting country}
more than once).
\item \code{partner} String, for bilateral perimeter of value added.
Default is \code{"WLD"}, but it can also be any country or
country group code (e.g. \code{"USA"} or \code{"EU27"}). In this case
(bilateral perspective), all flows that cross the bilateral
perimeter more than once will be considered as double counting.
\item \code{sector} String, for sector perimeter of value added.
Default is \code{"TOTAL"}, but it can also be any sector or
sector group code (e.g. \code{"MANUF"}. In this case (sector
perspective), all flows that cross the sector perimeter more than
once will be considered as double counting. The bilateral and sector
perspectives can be combined in a bilateral-sector perspective.
Please note that, when using the world perspective (\code{perim = "WLD"})
and the terms output (\code{output = "terms"}, the foreign double
counting will be automatically divided in two elements.
}}
}
\value{
A list object of class \code{exvadec} with several matrices
plus metadata.
}
\description{
Calculates the decomposition of value added in exports of a country
or a group of countries according to different methodologies.
}
\examples{
# Create a test wio
wio <- make_wio("iciotest")
# Make Borin and Mancini (2019) source decomposition for Spain
exvadec <- make_exvadec(wio, exporter = "ESP", method = "bm_src")
# Make Wang et al. (2013) decomposition for all countries
# expressed in the traditional 16 terms
exvadec <- make_exvadec(wio, method = "wwz", output = "terms")
}
\references{
\itemize{
\item Borin, A., & Mancini, M. (2019). Measuring What Matters in Global
Value Chains and Value-Added Trade (Policy Research Working Paper
No. 8804). World Bank.
\item Koopman, R., Wang, Z., & Wei, S.-J. (2014). Tracing Value-Added and
Double Counting in Gross Exports. American Economic Review, 104(2),
459–494.
\item Miroudot, S., & Ye, M. (2021). Decomposing Value Added in Gross
Exports. Economic Systems Research, 33(1), 67–87.
\item Wang, Z., Wei, S.-J., & Zhu, K. (2013). Quantifying International
Production Sharing at the Bilateral and Sector Levels (NBER Working
Paper No. 19677). National Bureau of Economic Research, Inc.
}
}
