% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_exvadec_bkdown.R
\name{get_exvadec_bkdown}
\alias{get_exvadec_bkdown}
\title{Get a summary decomposition of value added in exports}
\usage{
get_exvadec_bkdown(
  exvadec_object,
  exporter = "WLD",
  sector = "TOTAL",
  importer = "WLD"
)
}
\arguments{
\item{exvadec_object}{An \code{exvadec} object created by
\code{\link[=make_exvadec]{make_exvadec()}}.}

\item{exporter}{A character string with the code for the exporting country}

\item{sector}{Character code of sector}

\item{importer}{Character code of importer}
}
\value{
Print result and copy to clipboard
}
\description{
Detail from an \code{exvadec} decomposition of a country by sector and
by destination
}
\examples{
wio <- make_wio("wiodtest", quiet = TRUE)
exvadec <- make_exvadec(wio, quiet = TRUE)
get_exvadec_bkdown(exvadec, "ESP", "MANUF")
}
\author{
Enrique Feas
}
