% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim_div}
\alias{sim_div}
\title{Simulation of dividends}
\usage{
sim_div(
  n,
  mu,
  sigma,
  r = 0.05,
  log = FALSE,
  output = c("pf", "d"),
  seed = NULL
)
}
\arguments{
\item{n}{A positive integer specifying the length of the simulated output series.}

\item{mu}{A scalar indicating the drift.}

\item{sigma}{A positive scalar indicating the standard deviation of the innovations.}

\item{r}{A positive value indicating the discount factor.}

\item{log}{Logical. If true dividends follow a lognormal distribution.}

\item{output}{A character string giving the fundamental price("pf") or
dividend series("d"). Default is `pf'.}

\item{seed}{An object specifying if and how the random number generator (rng)
should be initialized. Either NULL or an integer will be used in a call to
\code{set.seed} before simulation. If set, the value is saved as "seed" attribute
of the returned value. The default, NULL, will not change rng state, and
return .Random.seed as the "seed" attribute. Results are different between
the parallel and non-parallel option, even if they have the same seed.}
}
\value{
A numeric vector of length n.
}
\description{
Simulate (log) dividends from a random walk with drift.
}
\details{
If log is set to FALSE (default value) dividends follow:

\deqn{d_t = \mu + d_{t-1} + \epsilon_t}{d[t] = \mu + d[t-1] + \epsilon[t],}

where \eqn{\epsilon \sim \mathcal{N}(0, \sigma^2)}{\epsilon - N(0, \sigma^2)}. The default parameters
are \eqn{\mu = 0.0373}, \eqn{\sigma^2 = 0.1574} and \eqn{d[0] = 1.3} (the initial value of the dividend sequence).
The above equation can be solved to yield the fundamental price:

\deqn{F_t = \mu(1+r)r^{-2} + r^{-1}d_t}{F[t] = \mu * (1 + r)/r^2 + d[t]/r.}

If log is set to TRUE then dividends follow a lognormal distribution or log(dividends) follow:

\deqn{\ln(d_t) = \mu + \ln(d_{t-1}) + \epsilon_t}{ln(d[t]) = \mu + ln(d[t-1]) + \epsilon[t],}

where \eqn{\epsilon \sim \mathcal{N}(0, \sigma^2)}{\epsilon - N(0, \sigma^2)}. Default parameters are
\eqn{\mu = 0.013}, \eqn{\sigma^2 = 0.16}. The fundamental price in this case is:

\deqn{F_t = \frac{1+g}{r-g}d_t}{F[t] = (1 + g)/(r -g) * d[t],}

where \eqn{1+g=\exp(\mu+\sigma^2/2)}{1 + g = exp(\mu + \sigma^2/2)}.
All default parameter values are those suggested by West (1988).
}
\examples{
# Price is the sum of the bubble and fundamental components
# 20 is the scaling factor
pf <- sim_div(100, r = 0.05, output = "pf", seed = 123)
pb <- sim_evans(100, r = 0.05, seed = 123)
p <- pf + 20 * pb

autoplot(p)
}
\references{
West, K. D. (1988). Dividend innovations and stock price volatility.
Econometrica: Journal of the Econometric Society, p. 37-61.
}
