% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ran.R
\name{ran_beta_binom}
\alias{ran_beta_binom}
\title{Beta-Binomial Random Samples}
\usage{
ran_beta_binom(n = 1, size = 1, prob = 0.5, theta = 0)
}
\arguments{
\item{n}{A non-negative whole number of the number of random samples to generate.}

\item{size}{A non-negative whole numeric vector of the number of trials.}

\item{prob}{A numeric vector of values between 0 and 1 of the probability of success.}

\item{theta}{A non-negative numeric vector of the dispersion for the mixture models (student, gamma-Poisson and beta-binomial).}
}
\value{
A numeric vector of the random samples.
}
\description{
This parameterization of the beta-binomial distribution uses an expected probability parameter, \code{prob}, and a dispersion parameter, \code{theta}. The parameters of the underlying beta mixture are \code{alpha = (2 * prob) / theta} and \code{beta = (2 * (1 - prob)) / theta}. This parameterization of \code{theta} is unconventional, but has useful properties when modelling. When \code{theta = 0}, the beta-binomial reverts to the binomial distribution. When \code{theta = 1} and \code{prob = 0.5}, the parameters of the beta distribution become \code{alpha = 1} and \code{beta = 1}, which correspond to a uniform distribution for the beta-binomial probability parameter.
}
\examples{
ran_beta_binom(10, 1, 0.5, 0)
}
\seealso{
Other ran_dist: 
\code{\link{ran_bern}()},
\code{\link{ran_binom}()},
\code{\link{ran_gamma_pois_zi}()},
\code{\link{ran_gamma_pois}()},
\code{\link{ran_gamma}()},
\code{\link{ran_lnorm}()},
\code{\link{ran_neg_binom}()},
\code{\link{ran_norm}()},
\code{\link{ran_pois_zi}()},
\code{\link{ran_pois}()},
\code{\link{ran_student}()}
}
\concept{ran_dist}
