% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev.R
\name{dev_neg_binom}
\alias{dev_neg_binom}
\title{Negative Binomial Deviances}
\usage{
dev_neg_binom(x, lambda = 1, theta = 0, res = FALSE)
}
\arguments{
\item{x}{A non-negative whole numeric vector of values.}

\item{lambda}{A non-negative numeric vector of means.}

\item{theta}{A non-negative numeric vector of the dispersion parameters for the gamma mixing distribution. The variance for the resultant gamma-Poisson distribution is lambda + lambda^2 * theta.}

\item{res}{A flag specifying whether to return the deviance residual as opposed to the deviance.}
}
\value{
An numeric vector of the corresponding deviances or deviance residuals.
}
\description{
Negative Binomial Deviances
}
\examples{
dev_neg_binom(c(1, 2, 5), 2, 3)
}
\seealso{
Other dev_dist: 
\code{\link{dev_bern}()},
\code{\link{dev_binom}()},
\code{\link{dev_gamma_pois}()},
\code{\link{dev_lnorm}()},
\code{\link{dev_norm}()},
\code{\link{dev_pois_zi}()},
\code{\link{dev_pois}()}
}
\concept{dev_dist}
