% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_empty.R
\name{drop_empty_rows}
\alias{drop_empty_rows}
\alias{drop_empty_columns}
\alias{drop_r}
\alias{drop_c}
\alias{drop_rc}
\title{Drop empty (with all NA's) rows/columns from data.frame/table}
\usage{
drop_empty_rows(x, excluded_rows = NULL, excluded_columns = NULL)

drop_empty_columns(x, excluded_rows = NULL, excluded_columns = NULL)

drop_r(x, excluded_rows = NULL, excluded_columns = NULL)

drop_c(x, excluded_rows = NULL, excluded_columns = NULL)

drop_rc(x)
}
\arguments{
\item{x}{data.frame/etable(result of \link{cro} and etc.)}

\item{excluded_rows}{character/logical/numeric rows which won't be dropped
and in which NAs won't be counted. If it is characters then they will be
considered as pattern/vector of patterns. Patterns will be matched with
Perl-style regular expression with values in the first column of \code{x}
(see \link[base]{grep}, \code{perl = TRUE} argument). Rows which have such
patterns will be excluded. By default for class 'etable' pattern is "#"
because "#" marks totals in the result of \link{cro}.}

\item{excluded_columns}{logical/numeric/characters columns which won't be
dropped and in which NAs won't be counted. By default for class 'etable' it
is first column - column with labels in table.}
}
\value{
data.frame with removed rows/columns
}
\description{
By default tables produced by functions \link{tables}, \link{cro}, 
\link{cro_fun} and \link{cro_fun_df} are created with all 
possible value labels. If values for this labels are absent in variable there 
are NA's in rows and columns. 
\code{drop_empty_rows}/\code{drop_empty_columns} are intended to remove 
these empty rows/columns. \code{drop_r} and \code{drop_c} are the same
functions with shorter names. \code{drop_rc} drops rows and columns
simultaneously.
}
\examples{
data(mtcars)
mtcars = apply_labels(mtcars,
            vs = "Engine",
            vs = num_lab("
                      0 V-engine 
                      1 Straight engine
                      9 Other
                      "),
            am = "Transmission",
            am = num_lab("
                     0 Automatic 
                     1 Manual
                     9 Other
                     ")
         )
with_empty = calculate(mtcars, cro(am, vs))

drop_empty_rows(with_empty)
drop_empty_columns(with_empty)
drop_rc(with_empty)
                        
}
