% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.1-classes.R, R/1.2-methods.R
\docType{class}
\name{ExprsArray-class}
\alias{ExprsArray-class}
\alias{show,ExprsArray-method}
\alias{[,ExprsArray,ANY,ANY-method}
\alias{[,ExprsArray-method}
\alias{$,ExprsArray-method}
\alias{subset,ExprsArray-method}
\alias{plot,ExprsArray,missing-method}
\alias{summary,ExprsArray-method}
\alias{getFeatures,ExprsArray-method}
\title{An S4 class to store feature and annotation data}
\usage{
\S4method{show}{ExprsArray}(object)

\S4method{[}{ExprsArray,ANY,ANY}(x, i, j)

\S4method{$}{ExprsArray}(x, name)

\S4method{subset}{ExprsArray}(x, subset, select)

\S4method{plot}{ExprsArray,missing}(x, y, a = 1, b = 2, c = 3, ...)

\S4method{summary}{ExprsArray}(object)

\S4method{getFeatures}{ExprsArray}(object)
}
\arguments{
\item{object, x}{An object of class \code{ExprsArray}.}

\item{i, j}{Subsets entire \code{ExprsArray} object via
\code{object@annot[i, j]}. Returns \code{object@annot[, j]} if
argument \code{i} is missing.}

\item{name}{Returns \code{object@annot[, name]}.}

\item{subset}{Subsets entire \code{ExprsArray} object via
\code{object@annot[subset, ]}. Can be used to rearrange feature order.}

\item{select}{Subsets entire \code{ExprsArray} object via
\code{object@annot[, select]}. Can be used to rearrange subject order.}

\item{y}{Leave missing. Argument exists because of \code{\link{plot}} generic definition.}

\item{a, b, c}{A numeric scalar. Indexes the first, second, and third dimensions to plot.
Set \code{c = 0} to plot two dimensions.}

\item{...}{Additional arguments passed to\code{plot} or \code{lattice::cloud}.}
}
\description{
An S4 class to store feature and annotation data
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Method to show \code{ExprsArray} object.

\item \code{[}: Method to subset \code{ExprsArray} object.

\item \code{$}: Method to subset \code{ExprsArray} object.

\item \code{subset}: Method to subset \code{ExprsArray} object.

\item \code{plot}: Method to plot two or three dimensions of data.

\item \code{summary}: Method to plot summary graphs for a sub-sample of feature data.

\item \code{getFeatures}: Method to return features within an \code{ExprsArray} object.
}}

\section{Slots}{

\describe{
\item{\code{exprs}}{A matrix. Stores the feature data.}

\item{\code{annot}}{A data.frame. Stores the annotation data.}

\item{\code{preFilter}}{Typically a list. Stores feature selection history.}

\item{\code{reductionModel}}{Typically a list. Stores dimension reduction history.}
}}

\seealso{
\code{\link{ExprsArray-class}}\cr
\code{\link{ExprsModel-class}}\cr
\code{\link{ExprsPipeline-class}}\cr
\code{\link{ExprsEnsemble-class}}\cr
\code{\link{ExprsPredict-class}}
}
